%% CIS II Galen Calibration
% Based on: Assignment 2 - Function solveRx; ASBR Fall 2019 by N. Lamaison
% Solving for translational component of camera-tool transformation
function [tx] = solveTx(RA, tA, RB, tB, Rx)

% Getting constants (these should be equal)
A_data = size(RA, 3);
B_data = size(RB, 3);

% Defining matrices for least-squares solution
LHS = zeros(3 * A_data, 3);
RHS = zeros(3 * A_data, 1);

% Constructing left-hand and right-hand matrices
for i = 1:A_data
    LHS(((3 * i) - 2):(3 * i), :) = RA(:, :, i) - eye(3);
    RHS(((3 * i) - 2):(3 * i), :) = Rx * tB(:, i) - tA(:, i);
end

% Calculating tx using least-squares solution
tx = LHS \ RHS;
end

